const engToHeb = {
  q: 'ת', w: "'", e: 'ק', r: 'ר', t: 'א', y: 'ט', u: 'ו', i: 'ן', o: 'ם', p: 'פ',
  a: 'ש', s: 'ד', d: 'ג', f: 'כ', g: 'ע', h: 'י', j: 'ח', k: 'ל', l: 'ך',
  z: 'ז', x: 'ס', c: 'ב', v: 'ה', b: 'נ', n: 'מ', m: 'צ',
  ',': 'ת', '/': 'ץ', ';': 'ף',
  Q: 'ת', W: "'", E: 'ק', R: 'ר', T: 'א', Y: 'ט', U: 'ו', I: 'ן', O: 'ם', P: 'פ',
  A: 'ש', S: 'ד', D: 'ג', F: 'כ', G: 'ע', H: 'י', J: 'ח', K: 'ל', L: 'ך',
  Z: 'ז', X: 'ס', C: 'ב', V: 'ה', B: 'נ', N: 'מ', M: 'צ'
};

const hebToEng = {
  'ת': ',', 'ץ': '/', 'ף': ';',
  '/': 'q', "'": 'w', 'ק': 'e', 'ר': 'r', 'א': 't', 'ט': 'y', 'ו': 'u', 'ן': 'i', 'ם': 'o', 'פ': 'p',
  'ש': 'a', 'ד': 's', 'ג': 'd', 'כ': 'f', 'ע': 'g', 'י': 'h', 'ח': 'j', 'ל': 'k', 'ך': 'l',
  'ז': 'z', 'ס': 'x', 'ב': 'c', 'ה': 'v', 'נ': 'b', 'מ': 'n', 'צ': 'm'
};

function countHebrew(text) {
  return (text.match(/[\u0590-\u05FF]/g) || []).length;
}
function countEnglish(text) {
  return (text.match(/[a-zA-Z,\/;]/g) || []).length;
}
function detectLanguage(text) {
  const hebCount = countHebrew(text);
  const engCount = countEnglish(text);
  if (hebCount === 0 && engCount === 0) return 'none';
  return hebCount > engCount ? 'he' : 'en';
}
function isUrl(word) {
  const lower = word.toLowerCase().trim();

  // אם המילה מתחילה ב-www או http או מסתיימת בסיומת אינטרנט אמיתית
  const urlPattern = /^(https?:\/\/|www\.)|(\.(com|net|org|gov|edu|il|co|io|me|biz|info|tv|us|uk|ru|de|fr|es|cn|jp|au))$/i;

  // בדיקה מדויקת: לא כל נקודה הופכת את זה לכתובת
  return urlPattern.test(lower);
}

function convertWord(word, lang) {
  if (isUrl(word)) return word;
  if (lang === 'he') return [...word].map(c => hebToEng[c] || c).join('');
  if (lang === 'en') return [...word].map(c => engToHeb[c] || c).join('');
  return word;
}
function convertTextAuto(text) {
  const lang = detectLanguage(text);
  return text.split(/\s+/).map(w => convertWord(w, lang)).join(' ');
}
function replaceTextInElement(el) {
  if (!el) return;
  if (el.tagName === 'INPUT' || el.tagName === 'TEXTAREA') {
    el.value = convertTextAuto(el.value);
    // שמירת מיקום הסמן לא בוצעה כאן כי input פשוט יסתדר לרוב
  } else if (el.isContentEditable) {
    // נחליף תוכן נקי - שים לב: זה מוחק פורמט עשיר
    el.textContent = convertTextAuto(el.textContent);
  }
}

// אם תרצה להפעיל ישירות בלי פקודת background (אופציונלי), תוכל להאזין ל־Ctrl+B כאן גם:
// ========================
// כל הקוד של המיפוי והפונקציות כאן, אותו דבר כמו ב‑content.js
// ========================

(function() {
  // מאזין ל‑Ctrl+B בדף עצמו
  document.addEventListener('keydown', (e) => {
    if (e.ctrlKey && e.key.toLowerCase() === 'b') {
      const activeEl = document.activeElement;
      if (activeEl && (activeEl.tagName === 'INPUT' || activeEl.tagName === 'TEXTAREA' || activeEl.isContentEditable)) {
        if (activeEl.tagName === 'INPUT' || activeEl.tagName === 'TEXTAREA') {
          activeEl.value = convertTextAuto(activeEl.value);
        } else if (activeEl.isContentEditable) {
          activeEl.textContent = convertTextAuto(activeEl.textContent);
        }
        e.preventDefault();
      }
    }
  });
})();
